
<?php $__env->startSection('content'); ?>

<title>Final Sales Invoice</title>

<?php
use NumberToWords\NumberToWords;
$numberToWords = new NumberToWords();
$numberTransformer = $numberToWords->getNumberTransformer('en');

?>


<div class="invoice">


  <br>


  <table class="table table-bordered w-100">
    <tr class="bg-light">
      <td colspan="10" style="text-align:center;font-size: 15px;text-transform: capitalize;font-weight: bold;"><b>Didar Enterprise Limited - Olympic<br>Final Sales Invoice</b><br>DSR: <?php echo e($data->staff_name); ?></td>
    </tr>
    <tr class="text-center">
     <td colspan="12">
      Market : <?php echo e($data->market); ?><br>
      Date : <?php echo e(date('d M Y',strtotime($data->invoice_date))); ?><br>
      Invoice No : <?php echo e($data->invoice_no); ?> <br>
      Transaction : <?php echo e($data->transaction_type); ?><br>
      Print  : <?php echo e(date('d M Y')); ?>, <?php echo e(date("h:i:s a")); ?><br>

    </td>

  </tr>



  <tr class="bg-light">
   <th>SL</th>
   <th style="width: 300px;">Product</th>
   <th>Carton/Piece</th>
   <th>R. Carton/Piece</th>
   <th>S. Carton/Piece</th>
   <th>Free</th>
   <th>Damage</th>
   <th>Price</th>
   <th>Sub Total</th>
 </tr>


 <tbody>

  <?php
  $i=1;
  $totalpurchaseamount = 0;
  ?>
  <?php if(isset($product)): ?>
  <?php $__currentLoopData = $product; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

  <?php
  $product = DB::table("products")->where("id",$p->product_id)->first();


  $sqty = DB::table("stocks")->where("invoice_no",$data->invoice_no)->where("product_id",$p->product_id)->where('status',Null)->sum("qty");
  $returnqty = DB::table("stocks")->where("invoice_no",$data->invoice_no)->where("product_id",$p->product_id)->where('status',Null)->sum("returnqty");

  $salescartons = floor($sqty / $product->unit_per_group);
  $salesremainingPieces = $sqty % $product->unit_per_group;

  $returncartons = floor($returnqty / $product->unit_per_group);
  $returnremainingPieces = $returnqty % $product->unit_per_group;


  $finalsalesqty = $sqty - $returnqty;
  $finalsalescartons = floor($finalsalesqty / $product->unit_per_group);
  $finalsalesremainingPieces = $finalsalesqty % $product->unit_per_group;

  $piece_price = $p->sales_price/$product->unit_per_group;
  $totalpieceprice = $piece_price*$finalsalesremainingPieces;
  $damageprice = $p->damage*$piece_price;


  $subtotal = (($finalsalescartons*$p->sales_price)+$totalpieceprice)-$damageprice;
  $totalpurchaseamount = $totalpurchaseamount+$subtotal;


  ?>

  
<?php if($sqty > 0 || $p->damage > 0): ?>

  <tr>
    <td><?php echo e($i++); ?></td>
    <td><?php echo e($p->product_name); ?></td>
    <td><?php if($p->carton > 0): ?> <?php echo e($p->carton); ?> <?php else: ?> 0 <?php endif; ?> -  <?php if($p->piece > 0): ?> <?php echo e($p->piece); ?> <?php else: ?> 0 <?php endif; ?></td>
    <td><?php if($p->returnscarton > 0): ?> <?php echo e($p->returnscarton); ?> <?php else: ?> 0 <?php endif; ?> - <?php if($p->returnspiece > 0): ?> <?php echo e($p->returnspiece); ?> <?php else: ?> 0 <?php endif; ?></td>
    <td><?php if($finalsalescartons > 0): ?> <?php echo e($finalsalescartons); ?> <?php else: ?> 0 <?php endif; ?> - <?php if($finalsalesremainingPieces > 0): ?> <?php echo e($finalsalesremainingPieces); ?> <?php else: ?> 0 <?php endif; ?></td>
    <td><?php echo e($p->free); ?></td>
    <td><?php echo e($p->damage); ?></td>
    <td><?php echo e($p->sales_price); ?></td>
    <td class="text-right">

      <?php if($p->carton == null and $p->piece == null): ?>

      (-) <?php echo e(number_format($p->damage*$piece_price,2)); ?> /-

      <?php else: ?>

      <?php echo e(number_format($subtotal,2)); ?> /-

      <?php endif; ?>

    </td>

  </tr>

  <?php endif; ?>


  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  <?php endif; ?>


</tbody>



<tr style="font-size: 14px;">

  <th colspan="8" style="text-align: right;">
    Total Amount :<br>
    Discount :<br>
    Transport Cost :<br>
    DSR Cost :<br>
    Grand Total :<br>
    Paid :<br>
    Due :
  </th>




  <th class="text-right">
    <?php echo e(number_format($data->total,2)); ?> /- <br>
    <?php echo e(number_format($data->discount,2)); ?> /-<br>
    <?php echo e(number_format($data->transport_cost,2)); ?> /-<br>
    <?php echo e(number_format($data->dsr_cost,2)); ?> /-<br>
    <?php echo e(number_format($data->grandtotal,2)); ?> /-<br>
    <?php echo e(number_format($data->paid,2)); ?> /-<br>
    <?php echo e(number_format($data->due,2)); ?> /-<br>

  </th>


</tr>


</table>

<span class="note">
  <span style="text-transform: capitalize; font-size: 14px;"><b>In Word: </b> <?php echo e($numberTransformer->toWords($data->grandtotal)); ?> Taka Only.</span>
</span>




<br><br>

<div class="row" style="font-size: 14px!important;">
  <div class="col-4">
    --------------------<br>
    DSR Signature
  </div>
  <div class="col-4" style="text-align:center;">
    <?php echo e($data->name); ?><br>
    --------------------<br>
    Prepared By
  </div>
  <div class="col-4" style="text-align:right;">
    --------------------<br>
    Authorized  Signature
  </div>
</div>
<br>
<center><span style="font-size: 13px; color: gray;">Developer By SoftwarefarmBD. <br>Phone: 01788283580</span></center>
<br>
<center><a href="#" class="btn btn-danger btn-sm print w-10" onclick="window.print();">Print</a></center>
<br>

</div>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('backend.reports.layouts.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/gloriousiterp/dealer.gloriousiterp.xyz/resources/views/backend/sales/finalsalesinvoice.blade.php ENDPATH**/ ?>