@extends('backend.reports.layouts.index')
@section('content')

<title>Payment Invoice</title>

@php
use NumberToWords\NumberToWords;
$numberToWords = new NumberToWords();
$numberTransformer = $numberToWords->getNumberTransformer('en');

@endphp



<div class="invoice">
{{-- 
  <center><img src="{{ url($company_info->banner) }}" id="header_image" class="img-fluid" style="max-height: 130px;"></center> --}}

  <br>


  <table class="table-bordered table w-100">
    <tr class="bg-light">
      <td colspan="11" style="text-align:center;font-size: 15px;text-transform: capitalize;font-weight: bold;">
        <x-backend.report-header />
        
        <b>Pending Sales Invoice</b><br>DSR: {{ $data->staff_name }}</td> 
    </tr>
    <tr class="text-center">
     <td colspan="12">
      Date : {{ date('d M Y',strtotime($data->payment_date)) }}<br>
      Invoice No : <b>#{{ $data->id }}</b> <br>
      Print  : {{ date('d M Y') }}, {{date("h:i:s a")}}<br>
    </td>


  </tr>



  <!-- <thead> -->
   <tr class="bg-light text-center">
     <th>SL</th>
     <th style="width:400px;">Title</th>
     <th>Payment</th>
   </tr>
   <!-- </thead> -->


   <tbody>


    <tr class="text-center">
      <td>1</td>
      <td>Due Payment</td>
      <td>{{ $data->payment }}/-</td>
    </tr>




  </tbody>



</table>

<br><br><br>

<span class="note">
  <span style="text-transform: capitalize; font-size: 16px;"><b>In Word: </b> {{ $numberTransformer->toWords($data->payment) }} Taka Only.</span>
</span>




<br>
<br>

<div class="row" style="font-size: 16px;">
  <div class="col-4">
    --------------------<br>
    DSR Signature
  </div>
  <div class="col-4" style="text-align:center;">
    {{ Auth()->user()->name }}<br>
    --------------------<br>
    Prepared By
  </div>
  <div class="col-4" style="text-align:right;">
    --------------------<br>
    Authorized  Signature
  </div>
</div>
<br>


</div>


<style type="text/css">
  

      .table-bordered td{
        border: 1px solid gray !important;
      }

      .table-bordered th{
        border: 1px solid gray !important;
      }
</style>

<x-backend.print />


@endsection