@extends('backend.layouts.index')
@section('content')


<div class="content-body">
	<div class="container-fluid mt-3">


		<div class="col-lg-12">
			<div class="card">
				<div class="card-body">
					<h4 class="card-title"><a href="{{ url('dashboard') }}" class="text-primary"><i class="fa fa-home"></i></a>&nbsp;&nbsp;<i class="fa fa-angle-right"></i>&nbsp;&nbsp; Setting</h4><br>

					@if ($errors->any())
					<div class="alert alert-danger">
						<ul>
							@foreach ($errors->all() as $error)
							<li>{{ $error }}</li>
							@endforeach
						</ul>
					</div>
					@endif

					@if(Session::has('message'))
					<h5 class="alert alert-success">{{ Session::get('message') }}</h5>
					@endif
					

					<div class="basic-form">
						<form method="post" class="row" action="{{ url("setting/store") }}" enctype="multipart/form-data">
							@csrf

							<div class="form-group col-md-12">
								<label>Company Name <span class="text-danger">*</span></label>
								<input type="text" name="company_name" class="form-control" required="" value="{{ @$setting->company_name }}">
							</div>


							<div class="form-group col-md-6">
								<label>Phone</label>
								<input type="text" name="phone" class="form-control" value="{{ @$setting->phone }}">
							</div>

							<div class="form-group col-md-6">
								<label>Address</label>
								<input type="text" name="address" class="form-control" value="{{ @$setting->address }}">
							</div>


							<div class="form-group col-md-12">
								<button type="submit" class="btn btn-primary">Save Now</button>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>

	</div>
</div>

@endsection


