@extends('backend.reports.layouts.index')
@section('content')

    <title>Final Sales Invoice</title>

    @php
        use NumberToWords\NumberToWords;
        $numberToWords = new NumberToWords();
        $numberTransformer = $numberToWords->getNumberTransformer('en');

    @endphp


    <div class="invoice">
        {{--
  <center><img src="{{ url($company_info->banner) }}" id="header_image" class="img-fluid" style="max-height: 130px;"></center> --}}

        <br>


        <table class="table table-bordered w-100">
            <tr class="bg-light">
                <td colspan="10" style="text-align:center;font-size: 15px;text-transform: capitalize;font-weight: bold;">
                    <x-backend.report-header />

                    <b>Final Sales Invoice</b><br>DSR: {{ $data->staff_name }}
                </td>
            </tr>
            <tr class="text-center">
                <td colspan="12">
                    Market : {{ $data->market }}<br>
                    Date : {{ date('d M Y', strtotime($data->invoice_date)) }}<br>
                    Invoice No : {{ $data->invoice_no }} <br>
                    Transaction : {{ $data->transaction_type }}<br>
                    Print : {{ date('d M Y') }}, {{ date('h:i:s a') }}<br>

                </td>

            </tr>



            <tr class="bg-light">
                <th>SL</th>
                <th style="width: 300px;">Product</th>
                <th>Carton/Piece</th>
                <th>R. Carton/Piece</th>
                <th>S. Carton/Piece</th>
                <th>Free</th>
                <th>Damage</th>
                <th>Damage Amount</th>
                <th>Price</th>
                <th>Sub Total</th>
            </tr>


            <tbody>

                @php
                    $i = 1;
                    $totalpurchaseamount = 0;
                    $damageAmount = 0;
                @endphp
                @if (isset($product_list))
                    @foreach ($product_list as $p)
                        @php
                            $product = DB::table('products')->where('id', $p->product_id)->first();

                            $sqty = DB::table('stocks')
                                ->where('invoice_no', $data->invoice_no)
                                ->where('product_id', $p->product_id)
                                ->where('status', null)
                                ->sum('qty');
                            $returnqty = DB::table('stocks')
                                ->where('invoice_no', $data->invoice_no)
                                ->where('product_id', $p->product_id)
                                ->where('status', null)
                                ->sum('returnqty');

                            $salescartons = $product->unit_per_group > 0 ? floor($sqty / $product->unit_per_group) : 0;
                            $salesremainingPieces = $product->unit_per_group > 0 ? $sqty % $product->unit_per_group : 0;

                            $returncartons =
                                $product->unit_per_group > 0 ? floor($returnqty / $product->unit_per_group) : 0;
                            $returnremainingPieces =
                                $product->unit_per_group > 0 ? $returnqty % $product->unit_per_group : 0;

                            $finalsalesqty = $sqty - $returnqty;
                            $finalsalescartons =
                                $product->unit_per_group > 0 ? floor($finalsalesqty / $product->unit_per_group) : 0;
                            $finalsalesremainingPieces =
                                $product->unit_per_group > 0 ? $finalsalesqty % $product->unit_per_group : 0;

                            $piece_price =
                                $product->unit_per_group > 0 ? $p->sales_price / $product->unit_per_group : 0;
                            $totalpieceprice = $piece_price * $finalsalesremainingPieces;
                            $damageprice = $p->damage * $piece_price;

                            $subtotal = $finalsalescartons * $p->sales_price + $totalpieceprice - $damageprice;
                            $totalpurchaseamount = $totalpurchaseamount + $subtotal;

                            $damageAmount = $damageAmount + $damageprice;

                        @endphp


                        @if ($sqty > 0 || $p->damage > 0)
                            <tr>
                                <td>{{ $i++ }}</td>
                                <td>{{ $p->product_name }}</td>
                                <td>
                                    @if ($p->carton > 0)
                                        {{ $p->carton }}
                                    @else
                                        0
                                        @endif - @if ($p->piece > 0)
                                            {{ $p->piece }}
                                        @else
                                            0
                                        @endif
                                </td>
                                <td>
                                    @if ($p->returnscarton > 0)
                                        {{ $p->returnscarton }}
                                    @else
                                        0
                                        @endif - @if ($p->returnspiece > 0)
                                            {{ $p->returnspiece }}
                                        @else
                                            0
                                        @endif
                                </td>
                                <td>
                                    @if ($finalsalescartons > 0)
                                        {{ $finalsalescartons }}
                                    @else
                                        0
                                        @endif - @if ($finalsalesremainingPieces > 0)
                                            {{ $finalsalesremainingPieces }}
                                        @else
                                            0
                                        @endif
                                </td>
                                <td>{{ $p->free }}</td>
                                <td>{{ $p->damage }}</td>
                                <td>{{ $p->damage * $piece_price }}</td>
                                <td>{{ $p->sales_price }}</td>
                                <td class="text-right">

                                    @if ($p->carton == null and $p->piece == null)
                                        (-)
                                        {{ number_format($p->damage * $piece_price, 2) }} /-
                                    @else
                                        {{ number_format($subtotal, 2) }} /-
                                    @endif

                                </td>

                            </tr>
                        @endif
                    @endforeach
                @endif


            </tbody>



            <tr style="font-size: 14px;">

                <th colspan="9" style="text-align: right;">
                    Total Amount :<br>
                    Discount :<br>
                    Transport Cost :<br>
                    DSR Cost :<br>
                    Grand Total :<br>
                    Paid :<br>
                    Due :<br>
                    Damage Amount :<br>
                </th>




                <th class="text-right">
                    {{ number_format($data->total, 2) }} /- <br>
                    {{ number_format($data->discount, 2) }} /-<br>
                    {{ number_format($data->transport_cost, 2) }} /-<br>
                    {{ number_format($data->dsr_cost, 2) }} /-<br>
                    {{ number_format($data->grandtotal, 2) }} /-<br>
                    {{ number_format($data->paid, 2) }} /-<br>
                    {{ number_format($data->due, 2) }} /-<br>
                    {{ number_format($damageAmount, 2) }} /-<br>

                </th>


            </tr>


        </table>

        <span class="note">
            <span style="text-transform: capitalize; font-size: 14px;"><b>In Word: </b>
                {{ $numberTransformer->toWords($data->grandtotal) }} Taka Only.</span>
        </span>




        <br><br>

        <div class="row" style="font-size: 14px!important;">
            <div class="col-4">
                --------------------<br>
                DSR Signature
            </div>
            <div class="col-4" style="text-align:center;">
                {{ $data->name }}<br>
                --------------------<br>
                Prepared By
            </div>
            <div class="col-4" style="text-align:right;">
                --------------------<br>
                Authorized Signature
            </div>
        </div>
        <br>


    </div>

    <x-backend.print />

@endsection
