@extends('backend.layouts.index')
@section('content')
    <div class="content-body">
        <div class="container-fluid mt-3">


            <div class="col-12">

                <div class="card">
                    <div class="card-body">

                        <h4 class="card-title"><a href="{{ url('dashboard') }}" class="text-primary"><i
                                    class="fa fa-home"></i></a>&nbsp;&nbsp;<i class="fa fa-angle-right"></i>&nbsp;&nbsp;Final
                            Sales</h4><br>


                        <form method="post" class="btn-submit" enctype="multipart/form-data">
                            @csrf

                            <div class="col-md-12 p-0 row">

                                <input type="hidden" value="{{ $sales->invoice_no }}" name="invoice_no" id="invoice_no">


                                <div class="form-group col-md-3">
                                    <label class="mb-1">Date:<span class="text-danger"
                                            style="font-size: 15px;">*</span></label>
                                    <div class="input-group mb-2">

                                        <input type="date" name="invoice_date" class="form-control"
                                            value="{{ $sales->invoice_date }}" required="" autocomplete="off"
                                            required="">

                                    </div>
                                </div>







                                <div class="form-group col-md-6">
                                    <label class="mb-1">DSR Name: <span class="text-danger"
                                            style="font-size: 15px;">*</span></label>
                                    <div class="input-group mb-2">
                                        <select class="form-control myselect" name="staff_id" id=
									"staff_id"
                                            required="">

                                            <option value="">- - - - -</option>

                                            @foreach ($staff as $s)
                                                <option value="{{ $s->id }}"
                                                    @if ($sales->staff_id == $s->id) selected="" @endif>
                                                    {{ $s->staff_name }}</option>
                                            @endforeach


                                        </select>

                                    </div>
                                </div>




                                <div class="form-group col-md-3">
                                    <label class="mb-1">Market: <span class="text-danger"
                                            style="font-size: 15px;">*</span></label>
                                    <div class="input-group mb-2">
                                        <select class="form-control myselect" name="market" id=
								"market"
                                            required="">

                                            <option value="{{ $sales->market }}">{{ $sales->market }}</option>

                                        </select>

                                    </div>
                                </div>



                                {{--
					<div class="form-group col-md-3">
						<label class="mb-1">Category Name: </label>
						<div class="input-group mb-2">
							<select class="form-control" name="category_id" id=
							"category_id" onchange="return getcatproduct();">

							<option value="0">- - - - -</option>

							@foreach ($category as $s)
							<option value="{{ $s->id }}">{{ $s->category_name }}</option>
							@endforeach


						</select>

					</div>
				</div>
				--}}




                                <div class="col-md-9">
                                    <div class="row">




                                        <div class="col-md-12">


                                            <div class="row">
                                                <div class="form-group col-md-12">
                                                    <label class="mb-1">Product Name: </label>
                                                    <div class="input-group mb-2">

                                                        <select class="form-control myselect" name="product_id"
                                                            id=
										"product_id"
                                                            onchange="return editsalescurrentcart()">
                                                            <option value="">- - - - -</option>

                                                            @foreach ($product as $p)
                                                                <option value="{{ $p->id }}">{{ $p->product_name }}
                                                                </option>
                                                            @endforeach



                                                        </select>

                                                    </div>
                                                </div>



                                            </div>

                                        </div>
                                    </div>


                                    <div class="col-md-12 p-0"
                                        style="height: 600px!important; overflow: auto; overflow-x: hidden;">
                                        <table class="table">
                                            <thead class="bg-primary text-white">
                                                <tr>
                                                    <th>SL</th>
                                                    <th>Product</th>
                                                    <th>Carton/Piece</th>
                                                    <th>Free</th>
                                                    <th>Return</th>
                                                    <th>Damage</th>
                                                    <th>Price</th>
                                                    <th>Total</th>
                                                    <th></th>

                                                </tr>
                                            </thead>

                                            <tbody id="showdata" style="color: black; font-weight: bold;">

                                            </tbody>
                                        </table>
                                    </div>




                                </div>




                                <div class="col-md-3">
                                    <div class="ibox-head myhead2 p-0">
                                        <div class="ibox-title2 bg-primary p-2 text-white"><i class="fa fa-plus"
                                                aria-hidden="true"></i>&nbsp;&nbsp;Account</div>
                                    </div>

                                    <div class="col-md-12 bg-light p-3">



                                        <div class="form-group">
                                            <label class="mb-1">Sub Total:</label>
                                            <div class="input-group mb-2">

                                                <input type="text" id="totalamount" name="totalamount"
                                                    class="form-control" readonly="" value="{{ $sales->total }}">

                                            </div>
                                        </div>




                                        <div class="form-group">
                                            <label class="mb-1">Discount:</label>
                                            <div class="input-group mb-2">

                                                <input type="text" id="discount" name="discount" class="form-control"
                                                    placeholder="Discount" onkeyup="calculatediscount();"
                                                    value="{{ $sales->discount }}" autocomplete="off" readonly="">

                                            </div>
                                        </div>


                                        <div class="form-group">
                                            <label class="mb-1">Transport Cost:</label>
                                            <div class="input-group mb-2">

                                                <input type="text" id="transport_cost" name="transport_cost"
                                                    class="form-control" onkeyup="calculatediscount();" value="0"
                                                    autocomplete="off" required="">

                                            </div>
                                        </div>


                                        <div class="form-group">
                                            <label class="mb-1">DSR Cost:</label>
                                            <div class="input-group mb-2">

                                                <input type="text" id="dsr_cost" name="dsr_cost"
                                                    class="form-control" onkeyup="calculatediscount();" value="0"
                                                    autocomplete="off" required="">

                                            </div>
                                        </div>



                                        <div class="form-group">
                                            <label class="mb-1">Grand Total:</label>
                                            <div class="input-group mb-2">

                                                <input type="text" id="grandtotal" name="grandtotal"
                                                    value="{{ $sales->grandtotal }}" class="form-control"
                                                    readonly="">

                                            </div>
                                        </div>


                                        <div class="form-group">
                                            <label class="mb-1">Paid:</label>
                                            <div class="input-group mb-2">
                                                <input type="text" id="paid" name="paid" class="form-control"
                                                    value="{{ $sales->paid }}" onkeyup="return paidcalculated();">

                                                <button class="btn btn-primary" type="button" data-toggle="modal" data-target="#exampleModal">Denomination</button>

                                            </div>
                                        </div>



                                        <div class="form-group">
                                            <label class="mb-1">Due:</label>
                                            <div class="input-group mb-2">
                                                <input type="text" id="due" name="due"
                                                    value="{{ $sales->due }}" class="form-control" readonly="">
                                            </div>
                                        </div>



                                        <div class="form-group">
                                            <label class="mb-1">Payment By:</label>
                                            <div class="input-group mb-2">
                                                <select class="form-control" name="transaction_type"
                                                    id="transaction_type">
                                                    <option value="Cash"
                                                        @if ($sales->transaction_type == 'Cash') selected="" @endif>Cash</option>
                                                    <option value="Bank"
                                                        @if ($sales->transaction_type == 'Bank') selected="" @endif>Bank</option>
                                                    <option value="Mobile Banking"
                                                        @if ($sales->transaction_type == 'Mobile Banking') selected="" @endif>Mobile Banking
                                                    </option>

                                                </select>

                                            </div>
                                        </div>



                                        {{-- <div class="form-group">
						<label class="mb-1">Damage Amount:</label>
						<div class="input-group mb-2">
							<input type="text" id="show_damage_amount" name="show_damage_amount" value="0" class="form-control"  readonly="">
						</div>
					</div> --}}



                                    </div>

                                </div>

                            </div>



                            <div class="col-md-3 mt-5" style="margin: 0 auto;">
                                <center>
                                    <label>Change Status:</label>
                                    <select class="form-control myselect" id="confirm" name="status"
                                        onchange="return confirmfunction()">
                                        <option value="">- - -</option>
                                        <option value="2">Edit Sales</option>
                                        <option value="1">Confirm Sales</option>

                                    </select>
                                </center>
                            </div>


                            <div class="col-12 border p-4 mt-4" id="submit">
                                <center>
                                    <input type="submit" name="submitbutton" id="invoicebutton" value="Submit Now"
                                        class="btn btn-primary text-white"
                                        style="width: 150px; font-weight: bold; border-radius: 30px;">&nbsp;
                                </center>
                            </div>


                            <div class="col-12 border p-4 mt-4" id="loading">
                                <center>
                                    <input disabled="" name="submitbutton" id="invoicebutton" value="Loading..."
                                        class="btn btn-primary text-white"
                                        style="width: 150px; font-weight: bold; border-radius: 30px;">&nbsp;
                                </center>
                            </div>



                        </form>



                    </div> <!-- end card body-->
                </div> <!-- end card -->
            </div><!-- end col-->

        </div>
    </div>

    <br>



	<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
		<div class="modal-dialog modal-lg" role="document">
			<div class="modal-content">

				<div class="modal-body">


					    <div class="container">
        <h3 class="mb-4">Cash Denominations</h3>
        <table class="table-bordered denomination-table w-100 p-3 text-center">
            <thead class="table-primary">
                <tr>
                    <th>Denomination</th>
                    <th>×</th>
                    <th>Count</th>
                    <th>=</th>
                    <th>Subtotal</th>
                </tr>
            </thead>
            <tbody>
                <!-- Denomination rows -->
                <tr data-denom="1">
                    <td>1</td><td>X</td>
                    <td><input type="number" class="form-control count"></td><td>=</td>
                    <td class="subtotal">0</td>
                </tr>
                <tr data-denom="2">
                    <td>2</td><td>X</td>
                    <td><input type="number" class="form-control count"></td><td>=</td>
                    <td class="subtotal">0</td>
                </tr>
                <tr data-denom="5">
                    <td>5</td><td>X</td>
                    <td><input type="number" class="form-control count"></td><td>=</td>
                    <td class="subtotal">0</td>
                </tr>
                <tr data-denom="10">
                    <td>10</td><td>X</td>
                    <td><input type="number" class="form-control count"></td><td>=</td>
                    <td class="subtotal">0</td>
                </tr>
                <tr data-denom="20">
                    <td>20</td><td>X</td>
                    <td><input type="number" class="form-control count"></td><td>=</td>
                    <td class="subtotal">0</td>
                </tr>
                <tr data-denom="50">
                    <td>50</td><td>X</td>
                    <td><input type="number" class="form-control count"></td><td>=</td>
                    <td class="subtotal">0</td>
                </tr>
                <tr data-denom="100">
                    <td>100</td><td>X</td>
                    <td><input type="number" class="form-control count"></td><td>=</td>
                    <td class="subtotal">0</td>
                </tr>
                <tr data-denom="200">
                    <td>200</td><td>X</td>
                    <td><input type="number" class="form-control count"></td><td>=</td>
                    <td class="subtotal">0</td>
                </tr>
                <tr data-denom="500">
                    <td>500</td><td>X</td>
                    <td><input type="number" class="form-control count"></td><td>=</td>
                    <td class="subtotal">0</td>
                </tr>
                <tr data-denom="1000">
                    <td>1000</td><td>X</td>
                    <td><input type="number" class="form-control count"></td><td>=</td>
                    <td class="subtotal">0</td>
                </tr>
            </tbody>
            <tfoot>
                <tr class="total-row">
                    <td colspan="4" class="text-end">Total</td>
                    <td id="total-amount">0</td>
                </tr>
            </tfoot>
        </table>

    </div>




				</div>

			</div>
		</div>

	</div>



    <script type="text/javascript">



        function getcatproduct() {

            var category_id = $("#category_id").val();



            $.ajax({
                url: "{{ url('getcatproduct') }}/" + category_id,
                type: "get",
                data: {},
                success: function(data) {

                    $("#product_id").html(data);
                    $("#brand_id").val('');
                }
            });


        }


        function getbrandproductsales() {

            var brand_id = $("#brand_id").val();


            $.ajax({
                url: "{{ url('getbrandproductsales') }}/" + brand_id,
                type: "get",
                data: {},
                success: function(data) {

                    showeditsalescurrentcart();

                },
                error: function(errors) {
                    alert("Product Already Added");
                }
            });


        }


        showeditsalescurrentcart();

        function editsalescurrentcart() {
            let id = $("#product_id").val();
            let invoice_no = $("#invoice_no").val();

            $.ajax({
                url: "{{ url('editsalescurrentcart') }}/" + id + "/" + invoice_no,
                type: 'GET',
                success: function(data) {

                    Command: toastr["success"]("Product Added Done")
                    toastr.options = {
                        "closeButton": true,
                        "debug": false,
                        "newestOnTop": false,
                        "progressBar": true,
                        "positionClass": "toast-top-right",
                        "preventDuplicates": false,
                        "onclick": null,
                        "showDuration": "300",
                        "hideDuration": "1000",
                        "timeOut": "3000",
                        "extendedTimeOut": "1000",
                        "showEasing": "swing",
                        "hideEasing": "linear",
                        "showMethod": "fadeIn",
                        "hideMethod": "fadeOut"
                    }


                    showeditsalescurrentcart();

                    $("#product_id").val('');


                },
                error: function(errors) {
                    alert("Product Already Added");
                }
            });

        }



        function showeditsalescurrentcart() {

            let invoice_no = $("#invoice_no").val();

            $.ajax({
                url: "{{ url('showeditsalescurrentcart') }}/" + invoice_no,
                type: 'get',
                data: {},
                success: function(data) {
                    $("#showdata").html(data);
                    var totalsalesamount = $("#totalsalesamount").val();
                    $("#totalamount").val(totalsalesamount);
                    $("#grandtotal").val(totalsalesamount);
                    $("#paid").val(totalsalesamount);
                    $("#due").val(0);

                },
                error: function(errors) {
                    alert("errors")
                }
            });

        }






        function editsalescartonupdate(id) {

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            let carton = $("#carton" + id).val();
            let invoice_no = $("#invoice_no").val();


            $.ajax({
                url: "{{ url('editsalescartonupdate') }}/" + id + "/" + invoice_no,
                type: 'get',
                data: {
                    carton: carton
                },
                success: function(data) {

                    Command: toastr["success"]("Product Quentity Update")
                    toastr.options = {
                        "closeButton": true,
                        "debug": false,
                        "newestOnTop": false,
                        "progressBar": true,
                        "positionClass": "toast-top-right",
                        "preventDuplicates": false,
                        "onclick": null,
                        "showDuration": "300",
                        "hideDuration": "1000",
                        "timeOut": "3000",
                        "extendedTimeOut": "1000",
                        "showEasing": "swing",
                        "hideEasing": "linear",
                        "showMethod": "fadeIn",
                        "hideMethod": "fadeOut"
                    }

                    showeditsalescurrentcart();




                },
                error: function(errors) {
                    alert("errors")
                }
            });

        }




        function editsalespieceupdate(id) {

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            let piece = $("#piece" + id).val();
            let invoice_no = $("#invoice_no").val();


            $.ajax({
                url: "{{ url('editsalespieceupdate') }}/" + id + "/" + invoice_no,
                type: 'get',
                data: {
                    piece: piece
                },
                success: function(data) {

                    Command: toastr["success"]("Product Quentity Update")
                    toastr.options = {
                        "closeButton": true,
                        "debug": false,
                        "newestOnTop": false,
                        "progressBar": true,
                        "positionClass": "toast-top-right",
                        "preventDuplicates": false,
                        "onclick": null,
                        "showDuration": "300",
                        "hideDuration": "1000",
                        "timeOut": "3000",
                        "extendedTimeOut": "1000",
                        "showEasing": "swing",
                        "hideEasing": "linear",
                        "showMethod": "fadeIn",
                        "hideMethod": "fadeOut"
                    }

                    showeditsalescurrentcart();



                },
                error: function(errors) {
                    alert("errors")
                }
            });

        }








        function editsalesfreeupdate(id) {

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            let free = $("#free" + id).val();
            let invoice_no = $("#invoice_no").val();


            $.ajax({
                url: "{{ url('editsalesfreeupdate') }}/" + id + "/" + invoice_no,
                type: 'get',
                data: {
                    free: free
                },
                success: function(data) {

                    Command: toastr["success"]("Product Quentity Update")
                    toastr.options = {
                        "closeButton": true,
                        "debug": false,
                        "newestOnTop": false,
                        "progressBar": true,
                        "positionClass": "toast-top-right",
                        "preventDuplicates": false,
                        "onclick": null,
                        "showDuration": "300",
                        "hideDuration": "1000",
                        "timeOut": "3000",
                        "extendedTimeOut": "1000",
                        "showEasing": "swing",
                        "hideEasing": "linear",
                        "showMethod": "fadeIn",
                        "hideMethod": "fadeOut"
                    }

                    showeditsalescurrentcart();



                },
                error: function(errors) {
                    alert("errors")
                }
            });

        }




        function editsalesreturncartonupdate(id) {

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            let returnscarton = $("#returnscarton" + id).val();
            let invoice_no = $("#invoice_no").val();




            $.ajax({
                url: "{{ url('editsalesreturncartonupdate') }}/" + id + "/" + invoice_no,
                type: 'get',
                data: {
                    returnscarton: returnscarton
                },
                success: function(data) {

                    Command: toastr["success"]("Return Carton Update")
                    toastr.options = {
                        "closeButton": true,
                        "debug": false,
                        "newestOnTop": false,
                        "progressBar": true,
                        "positionClass": "toast-top-right",
                        "preventDuplicates": false,
                        "onclick": null,
                        "showDuration": "300",
                        "hideDuration": "1000",
                        "timeOut": "3000",
                        "extendedTimeOut": "1000",
                        "showEasing": "swing",
                        "hideEasing": "linear",
                        "showMethod": "fadeIn",
                        "hideMethod": "fadeOut"
                    }

                    showeditsalescurrentcart();



                },
                error: function(errors) {
                    alert("errors")
                }
            });

        }




        function editsalesreturnpieceupdate(id) {

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            let returnspiece = $("#returnspiece" + id).val();
            let invoice_no = $("#invoice_no").val();


            $.ajax({
                url: "{{ url('editsalesreturnpieceupdate') }}/" + id + "/" + invoice_no,
                type: 'get',
                data: {
                    returnspiece: returnspiece
                },
                success: function(data) {

                    Command: toastr["success"]("Return Piece Update")
                    toastr.options = {
                        "closeButton": true,
                        "debug": false,
                        "newestOnTop": false,
                        "progressBar": true,
                        "positionClass": "toast-top-right",
                        "preventDuplicates": false,
                        "onclick": null,
                        "showDuration": "300",
                        "hideDuration": "1000",
                        "timeOut": "3000",
                        "extendedTimeOut": "1000",
                        "showEasing": "swing",
                        "hideEasing": "linear",
                        "showMethod": "fadeIn",
                        "hideMethod": "fadeOut"
                    }

                    showeditsalescurrentcart();



                },
                error: function(errors) {
                    alert("errors")
                }
            });

        }






        function editsalesdamageupdate(id) {

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            let damage = $("#damage" + id).val();
            let damagePrice = $("#damagePrice" + id).val();

            let invoice_no = $("#invoice_no").val();


            $.ajax({
                url: "{{ url('editsalesdamageupdate') }}/" + id + "/" + invoice_no,
                type: 'get',
                data: {
                    damage: damage,
                    damagePrice: damagePrice
                },
                success: function(data) {

                    Command: toastr["success"]("Damage Update")
                    toastr.options = {
                        "closeButton": true,
                        "debug": false,
                        "newestOnTop": false,
                        "progressBar": true,
                        "positionClass": "toast-top-right",
                        "preventDuplicates": false,
                        "onclick": null,
                        "showDuration": "300",
                        "hideDuration": "1000",
                        "timeOut": "3000",
                        "extendedTimeOut": "1000",
                        "showEasing": "swing",
                        "hideEasing": "linear",
                        "showMethod": "fadeIn",
                        "hideMethod": "fadeOut"
                    }

                    showeditsalescurrentcart();



                },
                error: function(errors) {
                    alert("errors")
                }
            });

        }




        function editsalespriceupdate(id) {

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            let price = $("#price" + id).val();
            let invoice_no = $("#invoice_no").val();


            $.ajax({
                url: "{{ url('editsalespriceupdate') }}/" + id + "/" + invoice_no,
                type: 'get',
                data: {
                    price: price
                },
                success: function(data) {

                    Command: toastr["success"]("Price Update")
                    toastr.options = {
                        "closeButton": true,
                        "debug": false,
                        "newestOnTop": false,
                        "progressBar": true,
                        "positionClass": "toast-top-right",
                        "preventDuplicates": false,
                        "onclick": null,
                        "showDuration": "300",
                        "hideDuration": "1000",
                        "timeOut": "3000",
                        "extendedTimeOut": "1000",
                        "showEasing": "swing",
                        "hideEasing": "linear",
                        "showMethod": "fadeIn",
                        "hideMethod": "fadeOut"
                    }

                    showeditsalescurrentcart();



                },
                error: function(errors) {
                    alert("errors")
                }
            });

        }




        function editsalesproductdiscount(id) {

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            let discount = $("#discount" + id).val();
            let invoice_no = $("#invoice_no").val();

            $.ajax({
                url: "{{ url('editsalesproductdiscount') }}/" + id + "/" + invoice_no,
                type: 'POST',
                data: {
                    discount: discount
                },
                success: function(data) {
                    Command: toastr["success"]("Product Discount Update")
                    toastr.options = {
                        "closeButton": true,
                        "debug": false,
                        "newestOnTop": false,
                        "progressBar": true,
                        "positionClass": "toast-top-right",
                        "preventDuplicates": false,
                        "onclick": null,
                        "showDuration": "300",
                        "hideDuration": "1000",
                        "timeOut": "3000",
                        "extendedTimeOut": "1000",
                        "showEasing": "swing",
                        "hideEasing": "linear",
                        "showMethod": "fadeIn",
                        "hideMethod": "fadeOut"
                    }

                    showsalesproductcart();
                },
                error: function(errors) {
                    alert("errors")
                }
            });

        }



        function calculatediscount() {
            let total = parseFloat($("#totalamount").val());
            let discount = parseFloat($("#discount").val());
            let transport_cost = parseFloat($("#transport_cost").val());
            let dsr_cost = parseFloat($("#dsr_cost").val());




            let totaldiscount = (parseFloat(total)) - (parseFloat(discount) + parseFloat(transport_cost) + parseFloat(
                dsr_cost));
            $("#grandtotal").val(parseFloat(totaldiscount.toFixed(2)));
            $("#paid").val(parseFloat(totaldiscount.toFixed(2)));

            let paid = parseFloat($("#paid").val());

            let due = (parseFloat(totaldiscount) - parseFloat(paid));
            $("#due").val(parseFloat(due.toFixed(2)));



        }



        function paidcalculated() {
            let total = parseFloat($("#totalamount").val());
            let discount = parseFloat($("#discount").val());
            let transport_cost = parseFloat($("#transport_cost").val());
            let dsr_cost = parseFloat($("#dsr_cost").val());

            let totaldiscount = (parseFloat(total)) - (parseFloat(discount) + parseFloat(transport_cost) + parseFloat(
                dsr_cost));


            let grandtotal = $("#grandtotal").val(parseFloat(totaldiscount));
            let paid = parseFloat($("#paid").val());

            let due = (parseFloat(totaldiscount) - parseFloat(paid));
            $("#due").val(parseFloat(due.toFixed(2)));


        }




        $("#loading").hide();
        $("#submit").hide();


        $(".btn-submit").submit(function(e) {
            e.preventDefault();

            $("#loading").show();
            $("#submit").hide();

            let invoice_no = $("#invoice_no").val();
            var status = $("#confirm").val();


            var data = $(this).serialize();
            $.ajax({
                url: '{{ url('editsalesledger') }}/' + invoice_no,
                method: 'POST',
                data: data,

                success: function(response) {

                    if (status == "1") {

                        window.open('{{ URL::to('/finalsalesinvoice') }}' + '/' + response, "blank");
                        location.href = ('{{ URL::to('/allsalesledger') }}');

                    } else {
                        window.open('{{ URL::to('/salesinvoice') }}' + '/' + response, "blank");
                        location.href = ('{{ URL::to('/pendingallsalesledger') }}');
                    }



                    $("#loading").hide();
                    $("#submit").show();



                },

                error: function(error) {
                    console.log(error)
                }
            });
        });



        function confirmfunction() {

            var status = $("#confirm").val();

            if (status == "1" || status == "2") {
                $("#submit").show();
            } else {
                $("#submit").hide();
            }
        }




				$(document).ready(function () {
    $('.count').on('input', function () {
        let total = 0;

        $('tbody tr').each(function () {
            let denom = parseInt($(this).attr('data-denom')); // safer than .data()

            if (isNaN(denom)) {
                console.warn('Missing or invalid data-denom:', this);
                return;
            }

            let count = parseInt($(this).find('.count').val()) || 0;
            let subtotal = denom * count;

            if (isNaN(subtotal)) {
                subtotal = 0;
            }

            $(this).find('.subtotal').text(subtotal);
            total += subtotal;
        });

        $('#total-amount').text(total);
        $("#paid").val(total);

		    let grandtotal = $("#grandtotal").val();
            let paid = parseFloat($("#paid").val());

            let due = (parseFloat(grandtotal) - parseFloat(paid));
            $("#due").val(parseFloat(due.toFixed(2)));


    });
});



    </script>


    <style type="text/css">
        input:focus {
            border-color: red !important;
        }
    </style>
@endsection
