@extends('backend.reports.layouts.index')
@section('content')

    <title>Stocks Reports</title>

    @php
        use NumberToWords\NumberToWords;
        $numberToWords = new NumberToWords();
        $numberTransformer = $numberToWords->getNumberTransformer('en');
    @endphp

    <div class="invoice">

        <br>

        <table class="table table-bordered w-100">
            <tr class="bg-light">
                <td colspan="7"
                    style="text-align:center;font-size: 15px;text-transform: capitalize;font-weight: bold; letter-spacing: 1px; padding: 10px;">
                    <b><x-backend.report-header /></b>
                    <br>Stock Reports
                    <br>
                    @if ($to_date != null)
                        {{ date('d M Y', strtotime($startdate)) }}
                    @endif
                    @if ($to_date != null)
                        - - - {{ date('d M Y', strtotime($to_date)) }}
                    @endif
                </td>
            </tr>

            <tr class="bg-light" style="font-weight: bold; letter-spacing: 0.6px;">
                <td>SL.</td>
                <td style="width:500px;">Product</td>
                <td>R. Carton/Piece</td>
                <td>S. Carton/Piece</td>
                <td>Free</td>
                <td>Available</td>
            </tr>

            <tbody>
                @php
                    $i = 1;
                    $stockvalue = 0;
                    $salesvalue = 0;
                    $damagevalue = 0;
                    $prevsalesvalue = 0;
                @endphp

                @if (isset($product))
                    @foreach ($product as $d)
                        @php
                            // Fetch received and sold quantities
                            if ($to_date == null) {
                                $rcarton = DB::table('stocks')
                                    ->where('product_id', $d->id)
                                    ->where('status', 'purchase')
                                    ->sum('carton');
                                $rpiece = DB::table('stocks')
                                    ->where('product_id', $d->id)
                                    ->where('status', 'purchase')
                                    ->sum('piece');
                                $rqty = DB::table('stocks')
                                    ->where('product_id', $d->id)
                                    ->where('status', 'purchase')
                                    ->sum('qty');
                                $rfree = DB::table('stocks')
                                    ->where('product_id', $d->id)
                                    ->where('status', 'purchase')
                                    ->sum('free');

                                $scarton = DB::table('stocks')
                                    ->where('product_id', $d->id)
                                    ->whereNull('status')
                                    ->sum('carton');
                                $spiece = DB::table('stocks')
                                    ->where('product_id', $d->id)
                                    ->whereNull('status')
                                    ->sum('piece');
                                $sqty = DB::table('stocks')
                                    ->where('product_id', $d->id)
                                    ->whereNull('status')
                                    ->sum('qty');
                                $returnqty = DB::table('stocks')
                                    ->where('product_id', $d->id)
                                    ->whereNull('status')
                                    ->sum('returnqty');
                                $damage = DB::table('stocks')
                                    ->where('product_id', $d->id)
                                    ->whereNull('status')
                                    ->sum('damage');
                                $sfree = DB::table('stocks')
                                    ->where('product_id', $d->id)
                                    ->whereNull('status')
                                    ->sum('free');
                            } else {
                                $rcarton = DB::table('stocks')
                                    ->where('product_id', $d->id)
                                    ->where('status', 'purchase')
                                    ->sum('carton');
                                $rpiece = DB::table('stocks')
                                    ->where('product_id', $d->id)
                                    ->where('status', 'purchase')
                                    ->sum('piece');
                                $rqty = DB::table('stocks')
                                    ->where('product_id', $d->id)
                                    ->where('status', 'purchase')
                                    ->sum('qty');
                                $rfree = DB::table('stocks')
                                    ->where('product_id', $d->id)
                                    ->where('status', 'purchase')
                                    ->sum('free');

                                $scarton = DB::table('stocks')
                                    ->where('product_id', $d->id)
                                    ->whereNull('status')
                                    ->whereBetween(DB::raw('DATE(created_at)'), [$startdate, $to_date])
                                    ->sum('carton');
                                $spiece = DB::table('stocks')
                                    ->where('product_id', $d->id)
                                    ->whereNull('status')
                                    ->whereBetween(DB::raw('DATE(created_at)'), [$startdate, $to_date])
                                    ->sum('piece');
                                $sqty = DB::table('stocks')
                                    ->where('product_id', $d->id)
                                    ->whereNull('status')
                                    ->whereBetween(DB::raw('DATE(created_at)'), [$startdate, $to_date])
                                    ->sum('qty');
                                $returnqty = DB::table('stocks')
                                    ->where('product_id', $d->id)
                                    ->whereNull('status')
                                    ->whereBetween(DB::raw('DATE(created_at)'), [$startdate, $to_date])
                                    ->sum('returnqty');
                                $damage = DB::table('stocks')
                                    ->where('product_id', $d->id)
                                    ->whereNull('status')
                                    ->whereBetween(DB::raw('DATE(created_at)'), [$startdate, $to_date])
                                    ->sum('damage');
                                $sfree = DB::table('stocks')
                                    ->where('product_id', $d->id)
                                    ->whereNull('status')
                                    ->whereBetween(DB::raw('DATE(created_at)'), [$startdate, $to_date])
                                    ->sum('free');
                            }

                            $piecesPerCarton = $d->unit_per_group ?? 0;

                            // Default values
                            $recievecartons = $recieveremainingPieces = 0;
                            $salescartons = $salesremainingPieces = 0;
                            $finalsalescartons = $finalsalesremainingPieces = 0;
                            $returncartons = $returnremainingPieces = 0;
                            $availablecartons = $availableremainingPieces = 0;

                            if ($piecesPerCarton > 0) {
                                $returncartons = floor($returnqty / $piecesPerCarton);
                                $returnremainingPieces = $returnqty % $piecesPerCarton;

                                $recievecartons = floor($rqty / $piecesPerCarton);
                                $recieveremainingPieces = $rqty % $piecesPerCarton;

                                $salescartons = floor($sqty / $piecesPerCarton);
                                $salesremainingPieces = $sqty % $piecesPerCarton;

                                $finalsalesqty = $sqty - $returnqty;
                                $finalsalescartons = floor($finalsalesqty / $piecesPerCarton);
                                $finalsalesremainingPieces = $finalsalesqty % $piecesPerCarton;

                                $available = $rqty - $finalsalesqty;
                                $pieces = $available;

                                $availablecartons = floor($pieces / $piecesPerCarton);
                                $availableremainingPieces = $pieces % $piecesPerCarton;
                            } else {
                                // If no carton info, just show everything as pieces
                                $finalsalesqty = $sqty - $returnqty;
                                $availableremainingPieces = $rqty - $finalsalesqty;
                            }

                            $availablefree = $rfree - $sfree;

                            // Avoid division by zero for price
                            $picespurchasepricee = $piecesPerCarton > 0 ? $d->purchase_price / $piecesPerCarton : 0;
                            $picessalespricee = $piecesPerCarton > 0 ? $d->sales_price / $piecesPerCarton : 0;

                            $stockvalue +=
                                $availablecartons * $d->purchase_price +
                                $availableremainingPieces * $picespurchasepricee;
                            $salesvalue +=
                                $availablecartons * $d->sales_price + $availableremainingPieces * $picessalespricee;
                            $damagevalue +=
                                $piecesPerCarton > 0 ? $damage * ($d->purchase_price / $piecesPerCarton) : 0;
                            $prevsalesvalue += $finalsalesqty * $picessalespricee;
                        @endphp

                        <tr>
                            <td>{{ $i++ }}</td>
                            <td class="text-left">
                                {{ $d->product_name }}<br>
                                <span style="font-size: 12px;">{{ $d->unit_per_group }} {{ $d->single_unit }}
                                    {{ $d->group_unit }}</span>
                            </td>
                            <td>{{ $recievecartons }} : {{ $recieveremainingPieces }}</td>
                            <td>{{ $finalsalescartons }} : {{ $finalsalesremainingPieces }}</td>
                            <th>{{ $availablefree }} P</th>
                            <td class="font-weight-bold">{{ $availablecartons }} : {{ $availableremainingPieces }}</td>
                        </tr>
                    @endforeach
                @endif
            </tbody>

            <tr>
                <th colspan="5" class="text-right">Previous Sales Value</th>
                <th>{{ number_format($prevsalesvalue, 2) }} /-</th>
            </tr>

            <tr>
                <th colspan="5" class="text-right">Available Stock Value</th>
                <th>{{ number_format($stockvalue, 2) }} /-</th>
            </tr>

            <tr>
                <th colspan="5" class="text-right">Available Sales Value</th>
                <th>{{ number_format($salesvalue, 2) }} /-</th>
            </tr>

        </table>

        <br><br>

        <div class="row" style="font-size: 14px;">
            <div class="col-4">
                --------------------<br>
                Manager Signature
            </div>
            <div class="col-4" style="text-align:center;">
                {{ Auth()->user()->name }}<br>
                --------------------<br>
                Prepared By
            </div>
            <div class="col-4" style="text-align:right;">
                --------------------<br>
                Authorized Signature
            </div>
        </div>
        <br>
    </div>

    <x-backend.print />
@endsection
