@extends('backend.reports.layouts.index')
@section('content')
    <title>Profit Reports</title>

    @php
        use NumberToWords\NumberToWords;
        $numberToWords = new NumberToWords();
        $numberTransformer = $numberToWords->getNumberTransformer('en');
    @endphp

    <div class="invoice">
        {{--
	<center><img src="{{ url($company_info->banner) }}" id="header_image" class="img-fluid" style="max-height: 130px;"></center> --}}



        <table class="table table-bordered w-100">
            <tr class="bg-light">
                <td colspan="11"
                    style="text-align:center;font-size: 14px;text-transform: capitalize;letter-spacing: 1px; padding: 10px;">
                    <x-backend.report-header />

                    <b>
                        <br>Profit Reports</b>
                    <br>
                    From Date - {{ request('from_date') }} @if (request('to_date'))
                        - To Date - {{ request('to_date') }}
                    @endif

                </td>
            </tr>
        </table>


        <div class="row">

            <div class="col-12">
                <table class="table-bordered w-100">



                    <!-- <thead> -->
                    <tr class="bg-light text-center" style="font-weight: bold; letter-spacing: 0.6px;">
                        <td>Invoice No</td>
                        <td>Product Information</td>
                        <td>Profit</td>
                    </tr>
                    <!-- </thead> -->


                    <tbody>

                        @php
                            $totalProfit = 0;
                        @endphp
                        @foreach ($data as $d)
                            @php
                                $salesEntry = DB::table('sales_entry')
                                    ->where('invoice_no', $d->invoice_no)
                                    ->join('products', 'products.id', 'sales_entry.product_id')
                                    ->when($productId, function ($query) use ($productId) {
                                        return $query->where('sales_entry.product_id', $productId);
                                    })
                                    ->select('sales_entry.*', 'products.product_name', 'products.unit_per_group')
                                    ->get();
                            @endphp

                            <tr class="text-center">
                                <td> {{ $d->invoice_no }}</td>
                                <td>
                                    <table class="table-bordered w-100">
                                        <tr class="bg-light text-center" style="font-weight: bold; letter-spacing: 0.6px;">
                                            <td>SL.</td>
                                            <td>Product</td>
                                            <td>Qty</td>
                                            <td>Gross Profit(Sales - Purchase)</td>
                                            <td>Net Profit(Gross Profit - Damage Profit)</td>
                                        </tr>
                                        @php
                                            $invoiceProfit = 0;
                                        @endphp
                                        @foreach ($salesEntry as $s)
                                            @if ($s->qty > 0)
                                                @php
                                                    $qty = $s->qty - $s->returnspiece;

                                                    $unitPurchasePrice = $s->purchase_price / $s->unit_per_group;
                                                    $unitSalesPrice = $s->sales_price / $s->unit_per_group;
                                                    $unitDamagePrice = $s->damage_price / $s->unit_per_group;
                                                    $purchasePrice = $qty * $unitPurchasePrice;
                                                    $salesPrice = $qty * $unitSalesPrice;

                                                    $uniteDamageProfit = $unitSalesPrice - $unitPurchasePrice;
                                                    $damageProfit = $s->damage * $uniteDamageProfit;

                                                    $profit = $salesPrice - $purchasePrice;
                                                    $netProfit = $profit - $damageProfit;

                                                    $invoiceProfit += $netProfit;

                                                @endphp
                                                <tr>
                                                    <td>{{ $loop->iteration }}</td>
                                                    <td>{{ $s->product_name }}</td>
                                                    <td>{{ $qty }}</td>
                                                    <td>{{ $profit }}</td>
                                                    <td>{{ $netProfit }}</td>
                                                </tr>
                                            @endif
                                        @endforeach

                                    </table>

                                    @php
                                        $totalProfit += $invoiceProfit;
                                    @endphp

                                </td>
                                <td>{{ $invoiceProfit }}/-</td>
                            </tr>
                        @endforeach


                    </tbody>

                    <tr class="text-center">
                        <th colspan="2" class="text-right">Total</th>
                        <th>{{ $totalProfit }}/-</th>
                    </tr>

                </table>

            </div>
        </div>
        <br>

        <div class="row" style="font-size: 14px;">
            <div class="col-4">
                --------------------<br>
                Manager Signature
            </div>
            <div class="col-4" style="text-align:center;">

                {{ Auth()->user()->name }}<br>
                --------------------<br>
                Prepared By
            </div>
            <div class="col-4" style="text-align:right;">
                --------------------<br>
                Authorized Signature
            </div>
        </div>
        <br>


    </div>


    <x-backend.print />
@endsection
