@extends('backend.reports.layouts.index')
@section('content')
    <title>Stocks Reports</title>

    @php
        use NumberToWords\NumberToWords;
        $numberToWords = new NumberToWords();
        $numberTransformer = $numberToWords->getNumberTransformer('en');

    @endphp


    <div class="invoice">


        <table class="table table-bordered w-100">
            <tr class="bg-light">
                <td colspan="7"
                    style="text-align:center;font-size: 15px;text-transform: capitalize;font-weight: bold; letter-spacing: 1px; padding: 10px;">
                    <x-backend.report-header />
                    <b>
                        Damage Reports</b>
                    <br>
                     Date: {{ request('start_date') }} To {{ request('end_date') }}

                </td>
            </tr>


        </table>


             <div class="col-12">
                <table class="table-bordered w-100">



                    <!-- <thead> -->
                    <tr class="bg-light text-center" style="font-weight: bold; letter-spacing: 0.6px;">
                        <td>Invoice No</td>
                        <td>Product Information</td>
                        <td>Damage</td>
                    </tr>
                    <!-- </thead> -->



                    <tbody>

                        @php
                            $totalProfit = 0;
                        @endphp
                        @foreach ($data as $d)
                            @php
                                $salesEntry = DB::table('sales_entry')
                                    ->where('invoice_no', $d->invoice_no)
                                    ->join('products', 'products.id', 'sales_entry.product_id')
                                    ->select('sales_entry.*', 'products.product_name', 'products.unit_per_group')
                                    ->get();
                            @endphp

                            <tr class="text-center">
                                <td> {{ $d->invoice_no }}</td>
                                <td>



                                    <table class="table-bordered w-100">
                                        <tr class="bg-light text-center" style="font-weight: bold; letter-spacing: 0.6px;">
                                            <td>SL.</td>
                                            <td>Product</td>
                                            <td>Qty</td>
                                            <td>Amount</td>
                                        </tr>


                                        @php
                                            $damageAmount = 0;
                                        @endphp
                                        @foreach ($salesEntry as $s)
                                            @if ($s->damage > 0)
                                                @php
                                                    $qty = $s->qty;

                                                    $unitPurchasePrice = $s->purchase_price / $s->unit_per_group;
                                                    $unitSalesPrice = $s->sales_price / $s->unit_per_group;

                                                    $purchasePrice = $qty * $unitPurchasePrice;
                                                    $salesPrice = $qty * $unitSalesPrice;

                                                    $profit = $salesPrice - $purchasePrice;

                                                    $damage = $s->damage;

                                                    $damageAmount += $damage * $unitSalesPrice;

                                                @endphp
                                                <tr>
                                                    <td>{{ $loop->iteration }}</td>
                                                    <td>{{ $s->product_name }}</td>
                                                    <td>{{ $damage }}</td>
                                                    <td>{{ $damage*$unitSalesPrice }}</td>
                                                </tr>
                                            @endif
                                        @endforeach

                                    </table>

                                    @php
                                        $totalProfit += $damageAmount;
                                    @endphp

                                </td>
                                <td>{{ $damageAmount }}/-</td>
                            </tr>
                        @endforeach


                    </tbody>

                    <tr class="text-center">
                        <th colspan="2" class="text-right">Total</th>
                        <th>{{ $totalProfit }}/-</th>
                    </tr>

                </table>


            </div>




        <br>
        <br>

        <div class="row" style="font-size: 14px;">
            <div class="col-4">
                --------------------<br>
                Manager Signature
            </div>
            <div class="col-4" style="text-align:center;">
                {{ Auth()->user()->name }}<br>
                --------------------<br>
                Prepared By
            </div>
            <div class="col-4" style="text-align:right;">
                --------------------<br>
                Authorized Signature
            </div>
        </div>
        <br>


    </div>


        <x-backend.print />
@endsection
