@extends('backend.reports.layouts.index')
@section('content')
    <title>Stocks Reports</title>

    @php
        use NumberToWords\NumberToWords;
        $numberToWords = new NumberToWords();
        $numberTransformer = $numberToWords->getNumberTransformer('en');

    @endphp


    <div class="invoice">


        <table class="table table-bordered w-100">
            <tr class="bg-light">
                <td colspan="7"
                    style="text-align:center;font-size: 15px;text-transform: capitalize;font-weight: bold; letter-spacing: 1px; padding: 10px;">
                    <x-backend.report-header />
                    <b>
                        <br>{{ request('type') }} Reports</b>
                    <br>
                     Date: {{ request('start_date') }} To {{ request('end_date') }}

                </td>
            </tr>

            <tr class="bg-light " style="font-weight: bold; letter-spacing: 0.6px;">

                <td>SL.</td>
                <td>Date</td>
                <td>Title</td>
                <td>Amount</td>

            </tr>



            <tbody>

                    @foreach ($data as $d)
                        <tr>
                            <td>{{ $loop->iteration }}</td>
                            <td>{{ $d->dates }}</td>
                            <td>{{ $d->title }}</td>
                            <td>{{ $d->amount }}/-</td>
                        </tr>
                    @endforeach


            </tbody>

            <tfoot>
                <tr>
                    <th colspan="3" class="text-right">Total</th>
                    <th>{{ number_format($data->sum('amount'),2) }}/-</th>
                </tr>
            </tfoot>




        </table>




        <br>
        <br>

        <div class="row" style="font-size: 14px;">
            <div class="col-4">
                --------------------<br>
                Manager Signature
            </div>
            <div class="col-4" style="text-align:center;">
                {{ Auth()->user()->name }}<br>
                --------------------<br>
                Prepared By
            </div>
            <div class="col-4" style="text-align:right;">
                --------------------<br>
                Authorized Signature
            </div>
        </div>
        <br>


    </div>


        <x-backend.print />
@endsection
