@extends('backend.layouts.index')
@section('content')
    <div class="content-body">
        <div class="container-fluid mt-3">


            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title"><a href="{{ url('dashboard') }}" class="text-primary"><i
                                    class="fa fa-home"></i></a>&nbsp;&nbsp;<i class="fa fa-angle-right"></i>&nbsp;&nbsp;Damage
                            Reports</h4><br>



                        <form action="{{ url('searchfulldamagereport') }}" target="_blank">
                            <div class="row align-items-center">
                                <div class="col-md-3 form-group">
                                    <label>From Date</label>
                                    <input type="date" name="start_date" class="form-control"
                                        value="{{ request('start_date') ?? defaultDate() }}" required>
                                </div>

                                <div class="col-md-3 form-group">
                                    <label>To Date</label>
                                    <input type="date" name="end_date" class="form-control"
                                        value="{{ request('end_date') ?? defaultDate() }}" required>
                                </div>

                             
                                
                                @php
                                    $markets = DB::table('market')->get();
                                @endphp

                                <div class="form-group col-md-3">
                                    <label class="mb-1">Market: </label>
                                    <div class="input-group mb-2">
                                        <select class="form-control myselect" name="market" id="market"
                                         >
                                            <option value="">- - - - -</option>
                                            @foreach ($markets as $market)
                                                <option value="{{ $market->name }}">{{ $market->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>



                                <div class="col-md-3 form-group">
                                    <br>
                                    <div class="d-flex">
                                        <button type="submit" class="btn btn-primary text-white w-100"><i
                                                class="fa fa-filter"></i>
                                            Filter</button>
                                        <a href="{{ url()->current() }}" class="btn btn-danger text-white w-100 ml-2"><i
                                                class="fa fa-refresh"></i> Reset</a>
                                    </div>
                                </div>

                            </div>
                        </form>



                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
