@extends('backend.layouts.index')
@section('content')
    <div class="content-body">
        <div class="container-fluid mt-3">


            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title"><a href="{{ url('dashboard') }}" class="text-primary"><i
                                    class="fa fa-home"></i></a>&nbsp;&nbsp;<i class="fa fa-angle-right"></i>&nbsp;&nbsp;Market

                            <button class="btn btn-primary float-right" data-toggle="modal" data-target="#exampleModal"><i
                                    class="fa fa-plus"></i>&nbsp;&nbsp;Add Market</button>
                        </h4>



                        <div class="table-responsive">
                            <table class="table table-striped table-bordered zero-configuration">
                                <thead>
                                    <tr class="bg-primary text-white">
                                        <th>SL.</th>
                                        <th>Name</th>
                                        <th>Option</th>
                                    </tr>
                                </thead>
                                <tbody>

                                    @foreach ($data as $d)
                                        <tr>
                                            <td>{{ $loop->iteration }}</td>
                                            <td>{{ $d->name }}</td>
                                            <td>
                                                <button class="btn btn-info editBtn"
                                                    data-info="{{ json_encode($d) }}"><i
                                                        class="fa fa-edit"></i></button>
                                                <a href="{{ url('market/delete/' . $d->id) }}" class="btn btn-danger"
                                                    onclick="return confirm('Are you sure?')">
                                                    <i class="fa fa-trash"></i>
                                                </a>
                                            </td>
                                        </tr>
                                    @endforeach


                                </tbody>

                            </table>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>





    <!-- Modal -->
    <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Market</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">

                    <form action="{{ url('market/store') }}" id="marketForm" method="post">
                        @csrf
                        <div class="form-group">
                            <label for="recipient-name" class="col-form-label">Market Name:</label>
                            <input type="text" name="name" class="form-control" id="recipient-name">
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Save</button>
                        </div>
                    </form>

                </div>

            </div>
        </div>
    </div>


    <script>
        $(document).ready(function() {
            $(document).on('click', '.editBtn', function() {
                var info = $(this).data('info');
                $('#exampleModal').modal('show');
                $('#recipient-name').val(info.name);
                $('#id').val(info.id);

                $('#marketForm').attr('action', '/market/update/' + info.id);
            });
        });
    </script>
@endsection
