@extends('backend.layouts.index')
@section('content')


    <div class="content-body">
        <div class="container-fluid mt-3">


      

            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title"><a href="{{ url('dashboard') }}" class="text-primary"><i
                                    class="fa fa-home"></i></a>&nbsp;&nbsp;<i
                                class="fa fa-angle-right"></i>&nbsp;&nbsp;Expense</h4>



                        <div class="table-responsive">
                            <table class="table table-striped table-bordered zero-configuration">
                                <thead>
                                    <tr class="bg-primary text-white">
                                        <th>SL.</th>
                                        <th>Date</th>
                                        <th>Title</th>
                                        <th>Amount</th>
                                        <th>Option</th>
                                    </tr>
                                </thead>
                                <tbody>

                                    @php $i =1; @endphp
                                    @if (isset($expense))
                                        @foreach ($expense as $d)
                                            <tr>
                                                <td>{{ $i++ }}</td>
                                                <td>{{ date('d M Y', strtotime($d->dates)) }}</td>
                                                <td>{{ $d->title }}</td>
                                                <td>{{ number_format($d->amount) }}</td>


                                                <td>
                                                    <div class="dropdown">
                                                        <button class="btn btn-primary text-white btn-sm dropdown-toggle"
                                                            type="button" id="dropdownMenuButton" data-toggle="dropdown"
                                                            aria-haspopup="true" aria-expanded="false">
                                                            Select Option
                                                        </button>
                                                        <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                                            <a class="dropdown-item p-2"
                                                                href="{{ url('deleteincomeexpense/' . $d->id) }}"
                                                                onclick="return confirm('Are you sure?')">Delete</a>
                                                        </div>
                                                    </div>

                                                </td>

                                            </tr>
                                        @endforeach
                                    @endif

                            </table>
                        </div>
                    </div>
                </div>
            </div>



            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title"><a href="{{ url('dashboard') }}" class="text-primary"><i
                                    class="fa fa-home"></i></a>&nbsp;&nbsp;<i
                                class="fa fa-angle-right"></i>&nbsp;&nbsp;Income</h4>



                        <div class="table-responsive">
                            <table class="table table-striped table-bordered zero-configuration">
                                <thead>
                                    <tr class="bg-primary text-white">
                                        <th>SL.</th>
                                        <th>Date</th>
                                        <th>Title</th>
                                        <th>Amount</th>
                                        <th>Option</th>
                                    </tr>
                                </thead>
                                <tbody>

                                    @php $i =1; @endphp
                                    @if (isset($income))
                                        @foreach ($income as $d)
                                            <tr>
                                                <td>{{ $i++ }}</td>
                                                <td>{{ date('d M Y', strtotime($d->dates)) }}</td>
                                                <td>{{ $d->title }}</td>
                                                <td>{{ number_format($d->amount) }}</td>


                                                <td>
                                                    <div class="dropdown">
                                                        <button class="btn btn-primary text-white btn-sm dropdown-toggle"
                                                            type="button" id="dropdownMenuButton" data-toggle="dropdown"
                                                            aria-haspopup="true" aria-expanded="false">
                                                            Select Option
                                                        </button>
                                                        <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                                            <a class="dropdown-item p-2"
                                                                href="{{ url('deleteincomeexpense/' . $d->id) }}"
                                                                onclick="return confirm('Are you sure?')">Delete</a>
                                                        </div>
                                                    </div>

                                                </td>

                                            </tr>
                                        @endforeach
                                    @endif

                            </table>
                        </div>
                    </div>
                </div>
            </div>




        </div>
    </div>




@endsection
