$(document).ready(function () {
    $(".zero-configuration").DataTable(),
        $(".default-ordering").DataTable({ order: [[3, "desc"]] }),
        $(".multi-ordering").DataTable({
            columnDefs: [
                { targets: [0], orderData: [0, 1] },
                { targets: [1], orderData: [1, 0] },
                { targets: [4], orderData: [4, 0] },
            ],
        }),
        $(".complex-headers").DataTable(),
        $(".dom-positioning").DataTable({
            dom: '<"top"i>rt<"bottom"flp><"clear">',
        }),
        $(".alt-pagination").DataTable({ pagingType: "full_numbers" }),
        $(".scroll-vertical").DataTable({
            scrollY: "200px",
            scrollCollapse: !0,
            paging: !1,
        }),
        $(".dynamic-height").DataTable({
            scrollY: "50vh",
            scrollCollapse: !0,
            paging: !1,
        }),
        $(".scroll-horizontal").DataTable({ scrollX: !0 }),
        $(".scroll-horizontal-vertical").DataTable({
            scrollY: 200,
            scrollX: !0,
        }),
        $(".comma-decimal-place").DataTable({
            language: { decimal: ",", thousands: "." },
        });

    var $t = $(".zero-configuration.js-totals");
    if ($t.length) {
        var api = $t.DataTable(); // returns existing instance if already initialized

        var parseNum = function (x) {
            if (typeof x === "string") {
                x = x.replace(/[^0-9.\-]/g, "");
                return parseFloat(x) || 0;
            }
            if (typeof x === "number") return x;
            return 0;
        };

        var fmt = function (n) {
            return n.toLocaleString(undefined, {
                minimumFractionDigits: 2,
                maximumFractionDigits: 2,
            });
        };

        var writeTotals = function () {
            var totalGrand = api
                .column(4, { page: 'current' })
                .data()
                .reduce((a, b) => a + parseNum(b), 0);
            var totalPaid = api
                .column(5, { page: 'current' })
                .data()
                .reduce((a, b) => a + parseNum(b), 0);
            var totalDue = api
                .column(6, { page: 'current' })
                .data()
                .reduce((a, b) => a + parseNum(b), 0);
            var totalDamage = api
                .column(7, { page: 'current' })
                .data()
                .reduce((a, b) => a + parseNum(b), 0);

            $(api.column(4).footer()).html(fmt(totalGrand));
            $(api.column(5).footer()).html(fmt(totalPaid));
            $(api.column(6).footer()).html(fmt(totalDue));
            $(api.column(7).footer()).html(fmt(totalDamage));
        };

        // initial fill + update on every draw (filtering, paging, sorting)
        writeTotals();
        api.on("draw", writeTotals);
    }
});
