<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Carbon\Carbon;
use Illuminate\Database\Query\Builder;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {

        Builder::macro('dateFilter', function ($column) {
            $start_date = request('start_date') ? Carbon::parse(request('start_date'))->format('Y-m-d') : defaultDate();
            $end_date   = request('end_date') ? Carbon::parse(request('end_date'))->format('Y-m-d') : defaultDate();

            if ($start_date && $end_date) {
                return $this->whereDate($column, '>=', $start_date)
                    ->whereDate($column, '<=', $end_date);
            }

            if ($start_date && !$end_date) {
                return $this->whereDate($column, '>=', $start_date);
            }

            if (!$start_date && $end_date) {
                return $this->whereDate($column, '<=', $end_date);
            }


            return $this->whereYear($column, now()->year)
                ->whereMonth($column, now()->month);

        });


        Builder::macro('filter', function (array $filters) {
            foreach ($filters as $requestKey => $column) {
                if (is_int($requestKey)) {
                    $requestKey = $column;
                }
                if (request()->filled($requestKey)) {
                    $this->where($column, request($requestKey));
                }
            }
            return $this;
        });
    }
}
