<?php

namespace App\Http\Controllers\backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class MarketController extends Controller
{
    public function index()
    {
        $data = DB::table('market')->orderByDesc('id')->get();
        return view('backend.market.index',compact('data'));
    }

    public function store(Request $request)
    {

        DB::table('market')->insert([
            'name' => $request->name
        ]);

        $notification = array(
            'messege' => 'Market Added Successfully',
            'alert-type' => 'success'
        );
        return redirect()->back()->with($notification);
      
    }

    public function destroy($id)
    {
        DB::table('market')->where('id',$id)->delete();
        $notification = array(
            'messege' => 'Market Deleted Successfully',
            'alert-type' => 'success'
        );
        return redirect()->back()->with($notification);
    }


    public function update(Request $request, $id)
    {
        DB::table('market')->where('id',$id)->update([
            'name' => $request->name
        ]);

        $notification = array(
            'messege' => 'Market Updated Successfully',
            'alert-type' => 'success'
        );
        return redirect()->back()->with($notification);
    }
}
