<?php

namespace App\Http\Controllers;

use DB;
use App\Models\Brand;
use Illuminate\Http\Request;

class ReportsController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }


    public function stockreports()
    {

        $data['category'] = DB::table("categories")->get();
        $data['brand'] = Brand::get();

        return view("backend.reports.stockreports", $data);
    }



    public function searchstockreports(Request $r)
    {
        $category = $r->category_id;
        $brand = $r->brand_id;
        $from_date = $r->from_date;
        $to_date = $r->to_date;

        $startdate = "2023-01-01";

        if ($category == "all" && $brand == "all") {
            // No filters
            $product = DB::table("products")->get();
        } elseif ($category == "all" && $brand != "all") {
            // Filter by brand only
            $product = DB::table("products")
                ->where('brand_id', $brand)
                ->get();
        } elseif ($category != "all" && $brand == "all") {
            // Filter by category only
            $product = DB::table("products")
                ->where('category_id', $category)
                ->get();
        } else {
            // Filter by both category and brand
            $product = DB::table("products")
                ->where('category_id', $category)
                ->where('brand_id', $brand)
                ->get();
        }

        return view("backend.reports.searchstockreports", compact('product', 'from_date', 'to_date', 'startdate'));
    }

    public function dsrreports()
    {

        $data['staff'] = DB::table("staff")->get();

        return view("backend.reports.dsrreports", $data);
    }



    public function searchdsrreports(Request $r)
    {

        $staff = $r->staff_id;
        $from_date = $r->from_date;
        $to_date = $r->to_date;

        if ($staff == "all") {

            if ($from_date == null && $to_date == null) {
                $ledger = DB::table("sales_ledger")
                    ->join('staff', 'staff.id', 'sales_ledger.staff_id')
                    ->select("sales_ledger.*", 'staff.staff_name')
                    ->get();

                $duepayment = DB::table("sales_payment")
                    ->where("sales_payment.invoice_no", "duepayment")
                    ->orderBy("sales_payment.id", 'DESC')
                    ->join('staff', 'staff.id', 'sales_payment.staff_id')
                    ->select("sales_payment.*", 'staff.staff_name')
                    ->get();
            } else {


                if ($to_date == null) {
                    $ledger = DB::table("sales_ledger")
                        ->whereDate('sales_ledger.invoice_date', $r->from_date)
                        ->join('staff', 'staff.id', 'sales_ledger.staff_id')
                        ->select("sales_ledger.*", 'staff.staff_name')
                        ->get();

                    $duepayment = DB::table("sales_payment")
                        ->where("sales_payment.invoice_no", "duepayment")
                        ->whereDate('sales_payment.payment_date', $r->from_date)
                        ->orderBy("sales_payment.id", 'DESC')
                        ->join('staff', 'staff.id', 'sales_payment.staff_id')
                        ->select("sales_payment.*", 'staff.staff_name')
                        ->get();
                } else {

                    $ledger = DB::table("sales_ledger")
                        ->whereBetween('sales_ledger.invoice_date', array($from_date, $to_date))
                        ->join('staff', 'staff.id', 'sales_ledger.staff_id')
                        ->select("sales_ledger.*", 'staff.staff_name')
                        ->get();

                    $duepayment = DB::table("sales_payment")
                        ->where("sales_payment.invoice_no", "duepayment")
                        ->whereBetween('sales_payment.payment_date', array($from_date, $to_date))
                        ->orderBy("sales_payment.id", 'DESC')
                        ->join('staff', 'staff.id', 'sales_payment.staff_id')
                        ->select("sales_payment.*", 'staff.staff_name')
                        ->get();
                }
            }
        } else {


            if ($from_date == null && $to_date == null) {
                $ledger = DB::table("sales_ledger")
                    ->where("sales_ledger.staff_id", $staff)
                    ->join('staff', 'staff.id', 'sales_ledger.staff_id')
                    ->select("sales_ledger.*", 'staff.staff_name')
                    ->get();

                $duepayment = DB::table("sales_payment")
                    ->where("sales_payment.invoice_no", "duepayment")
                    ->where("sales_payment.staff_id", $staff)
                    ->orderBy("sales_payment.id", 'DESC')
                    ->join('staff', 'staff.id', 'sales_payment.staff_id')
                    ->select("sales_payment.*", 'staff.staff_name')
                    ->get();
            } else {

                if ($to_date == null) {
                    $ledger = DB::table("sales_ledger")
                        ->where("sales_ledger.staff_id", $staff)
                        ->whereDate('sales_ledger.invoice_date', $r->from_date)
                        ->join('staff', 'staff.id', 'sales_ledger.staff_id')
                        ->select("sales_ledger.*", 'staff.staff_name')
                        ->get();

                    $duepayment = DB::table("sales_payment")
                        ->where("sales_payment.invoice_no", "duepayment")
                        ->whereDate('sales_payment.payment_date', $r->from_date)
                        ->where("sales_payment.staff_id", $staff)
                        ->orderBy("sales_payment.id", 'DESC')
                        ->join('staff', 'staff.id', 'sales_payment.staff_id')
                        ->select("sales_payment.*", 'staff.staff_name')
                        ->get();
                } else {
                    $ledger = DB::table("sales_ledger")
                        ->where("sales_ledger.staff_id", $staff)
                        ->whereBetween('sales_ledger.invoice_date', array($from_date, $to_date))
                        ->join('staff', 'staff.id', 'sales_ledger.staff_id')
                        ->select("sales_ledger.*", 'staff.staff_name')
                        ->get();

                    $duepayment = DB::table("sales_payment")
                        ->where("sales_payment.invoice_no", "duepayment")
                        ->whereBetween('sales_payment.payment_date', array($from_date, $to_date))
                        ->where("sales_payment.staff_id", $staff)
                        ->orderBy("sales_payment.id", 'DESC')
                        ->join('staff', 'staff.id', 'sales_payment.staff_id')
                        ->select("sales_payment.*", 'staff.staff_name')
                        ->get();
                }
            }
        }



        return view("backend.reports.searchdsrreports", compact('from_date', 'to_date', 'ledger', 'duepayment'));
    }



    public function profitreports()
    {

        return view("backend.reports.profitreports");
    }


    public function searchprofitreports(Request $r)
    {

        $start_date = $r->from_date;
        $end_date = $r->to_date;
        $market = $r->market;
        $productId = $r->product_id;

        $data = DB::table('sales_ledger')
            ->when($start_date && $end_date, function ($q) use ($start_date, $end_date) {
                return $q->whereBetween('sales_ledger.invoice_date', [$start_date, $end_date]);
            })
            ->when($start_date && !$end_date, function ($q) use ($start_date) {
                return $q->whereDate('sales_ledger.invoice_date', '>=', $start_date);
            })
            ->when(!$start_date && $end_date, function ($q) use ($end_date) {
                return $q->whereDate('sales_ledger.invoice_date', '<=', $end_date);
            })
            ->when($market, function ($q) use ($market) {
                return $q->where('sales_ledger.market', $market);
            })
            ->when($productId, function ($q) use ($productId) {
                return $q->where('sales_ledger.product_id', $productId);
            })
            ->whereNotNull('sales_ledger.status')
            ->get();

        return view("backend.reports.searchprofitreports", compact('start_date', 'end_date', 'market', 'data', 'productId'));
    }


    public function incomeExpenseReports()
    {

        return view("backend.reports.income-expense-reports");
    }


    public function searchIncomeExpenseReports(Request $r)
    {


        $type = $r->type;
        $data = DB::table('incomeexpense')
            ->dateFilter('dates')
            ->where('type', $type)
            ->get();


        return view("backend.reports.search-income-expense-reports", compact('data', 'type'));
    }


    public function fulldamagereport()
    {

        return view("backend.reports.fulldamagereport");
    }

    public function searchfulldamagereport(Request $r)
    {


        $start_date = $r->start_date;
        $end_date = $r->end_date;
        $market = $r->market;

        $data = DB::table('sales_ledger')
            ->dateFilter('invoice_date')
            ->when($market, function ($q) use ($market) {
                return $q->where('market', $market);
            })
            ->get();


        return view("backend.reports.searchfulldamagereport", compact('start_date', 'end_date', 'market', 'data'));
    }
}
