<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Auth;

class IncomeexpenseController extends Controller
{
	public function __construct()
	{
		$this->middleware('auth');

	}

	public function create(){

		return view("backend.incomeexpense.create");
	}

	public function store(Request $r){

		DB::table("incomeexpense")->insert([

			'dates'      => $r->date,
			'type'       => $r->type,
			'title'      => $r->title,
			'amount'     => $r->amount,
			'created_at' => now(),
		]);


		$notification=array(
			'messege'=>'Income/Expense Entry Done',
			'alert-type'=>'success'
		);
		return Redirect()->back()->with($notification); 
	}


	public function index(){

		$expense = DB::table("incomeexpense")->orderBy('id','DESC')->where("type","expense")->dateFilter('dates')->get();
		$income  = DB::table("incomeexpense")->orderBy('id','DESC')->where("type","income")->dateFilter('dates')->get();
		
		return view("backend.incomeexpense.index",compact('expense','income'));
	}



	public function delete($id){

		DB::table("incomeexpense")->where('id',$id)->delete();

		$notification=array(
			'messege'=>'Income/Expense Delete Done',
			'alert-type'=>'success'
		);
		return Redirect()->back()->with($notification); 
	}



}
